
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "beeper.hh"
#include "global_beep.hh"

void global_touch_recognized_beep()
{
  static beeper* touch_recognized_beeper = 0;
 
  if(!touch_recognized_beeper)
    {
      touch_recognized_beeper = new beeper ( 1.1 /* amplitude */,
                                             400.0 /*Hz*/,
                                             60 /*milliseconds*/);
    }

  touch_recognized_beeper->beep();
}

void global_entry_accepted_beep()
{
  static beeper* entry_accepted_beeper   = 0;
  if(!entry_accepted_beeper)
    entry_accepted_beeper = new beeper ( 1.5 /* amplitude */,
                                         800.0 /*Hz*/,
                                         60 /*milliseconds*/);

  entry_accepted_beeper->beep();
}

void global_entry_rejected_beep()
{
  static beeper* entry_rejected_beeper   = 0;

  if(!entry_rejected_beeper)
    entry_rejected_beeper = new beeper (12.50 /* amplitude */,
                                        50.0 /*Hz*/,
                                        60 /*milliseconds*/);
  
  entry_rejected_beeper->beep();
}
