
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "draw_text.hh"

#include <stdint.h>
#include <ft2build.h>
#include FT_FREETYPE_H


int main(int argc, char**argv)
{
  int error;
  bool progress = true;

  
  if(argc!=2)
    {
      printf("\nUsage:  check_font_symbol_range path/font.ttf\n\n");
      exit(20);
    }
  
  const char* fontname = argv[1];


  FILE* fp = fopen(fontname, "r");
  if(!fp)
    {
      printf("Error:  Input font file \"%s\" doesn't exist.\n", fontname);
      exit(20);
    }

  
  auto library = new FT_Library;
  auto face    = new FT_Face;
  
  
  error = FT_Init_FreeType( library );
  if(error)
    {
      printf("Error:  Freetype2 failed to initialize.\n");
      exit(20);
    }

  error = FT_New_Face(*library,
		      fontname,
		      0,
		      face);

      
  if(error)
    {
      printf("Error:  Can't load font \"%s\" into libFreetype.\n", fontname);
      exit(20);
    }      

  uint32_t start = 0;


  for(uint32_t unicode=1; unicode!=0; unicode++)
    {
      int index = FT_Get_Char_Index(*face, (char32_t)unicode);

      if(progress)
	if(unicode%100000000ll==0)
	  fprintf(stderr, "Progress:  %lld%%\n", (long long)unicode * 100 / (long long)(uint32_t(0)-1));

      if(index)
	{
	  // Have a glyph for this unicode
	  if(start==0)
	    {
	      start = unicode;
	    }
	}
      else
	{
	  if(start!=0)
	    {
	      uint32_t end = unicode-1;
	      printf("  { %6lld, %6lld },\n", (long long)start, (long long)end);
	      start=0;
	    }
	}
    }

  printf("  { %6d, %6d },\n", 0, 0);

  delete library;
  delete face;
}

