
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef BUTTON_HH
#define BUTTON_HH

#include "window.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "event_types.hh"
#include "send_events.hh"
#include "multilingua.hh"

//
// This is the type of button that you push for an action.
// It doesn't stay pushed.  For that, use a multiselect
// with only a single selection.
//

typedef void push_function(class button* b, void* data);


class button : public window, public sending_base_class<selection_changed_event, int>
{  
  int              x_margin_percent;
  int              y_margin_percent;
  int              circle_width_percent;
  
  int              top_margin;
  int              bottom_margin;
  int              left_margin;
  int              right_margin;
  int              font_height;
  int              circle_width;
  
  push_function*   pf;
  void*            pf_data;

  bool             enabled;

public:
  multilingua      name;

  color            FG_COLOR;
  dt_colors        TEXT_COLORS;
  color            FLASH_FG_COLOR;
  dt_colors        FLASH_TEXT_COLORS;

  bool             tighten_x;
  bool             tighten_y;
  
  bool             silent;
  bool             enable_flash;

  int              highlight_count;
  int              flash_count;

  void             enable();
  void             disable();
  
  virtual void     push();
  virtual void     release();

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

  virtual int      calculate_preferred_width(int height);
  
  // T is char, wchar_t, char16_t, or char32_t
  template<class T> void set_name(const T* name, int language=0);
  
  virtual bool     handle_event(my_event& me);

  button(const multilingua&   name,
	 int                  x_margin_percent,
	 int                  y_margin_percent,
	 int                  circle_width_percent,
	 dt_colors&           textcolors,
	 color                fg,
	 dt_colors&           flash_textcolor,
	 color                flash_fg,
	 push_function*       pf = 0,
	 void*                pf_data = 0,
	 bool                 tighten_x = false,
	 bool                 tighten_y = false);

  virtual ~button();
};


template<class T> void button::set_name(const T* name, int language)
{
  this->name.set_text(name, language);
}


#endif
