
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef LAYOUT_HH
#define LAYOUT_HH

#include "List.hh"
#include "window.hh"

class layout_plan
{
public:
  virtual void do_layout(int x, int y, int w, int h, int xmargin, int ymargin, List<window>& windowlist, int aspect_x=3, int aspect_y=2, bool force_aspect=false);
  layout_plan() {}
  virtual ~layout_plan() {}
};

class horizontal_layout_plan : public layout_plan
{
  virtual void do_layout(int x, int y, int w, int h, int xmargin, int ymargin, List<window>& windowlist, int aspect_x=3, int aspect_y=2, bool force_aspect=false);
};

class vertical_layout_plan : public layout_plan
{
  virtual void do_layout(int x, int y, int w, int h, int xmargin, int ymargin, List<window>& windowlist, int aspect_x=3, int aspect_y=2, bool force_aspect=false);
};

#endif
