
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef MULTISELECT_HH
#define MULTISELECT_HH

#include "multiwindow.hh"
#include "layout.hh"
#include "global_beep.hh"
#include "draw_text.hh"
#include "all_svg.hh"
#include "backing_panel.hh"
#include "event_types.hh"
#include "send_events.hh"
#include "multilingua.hh"

typedef void selection_change_function(selection_changed_event* sce, class multiselect* ms, void* data);

class multiselect : public window, public sending_base_class<selection_changed_event, int>
{
public:

  // Selection change events can be handled through the sophisticated
  // event mechanism, or in a simple way by setting this function.
  selection_change_function* change_function;
  void*                      change_function_data;
  
  const static int MAX_ITEMS   = 20;

  multilingua   title;   // If string has zero length, don't display title
  
  int           num_items;
  multilingua   item_name  [MAX_ITEMS];
  bool          selected   [MAX_ITEMS];
  bool          disabled   [MAX_ITEMS];

  color textcolor                [MAX_ITEMS];
  color selectedtextcolor        [MAX_ITEMS];
  color selected_highlight_color [MAX_ITEMS];
  
  color BOXCOLOR;
  color GROUPCOLOR;
  color SELECTED_HIGHLIGHT_COLOR;
  color TEXTCOLOR;
  color SELECTEDTEXTCOLOR;
  color DISABLEDTEXTCOLOR;
  color TITLECOLOR;

  int allowed_height;

  int below_title_margin;
  int below_title_offset;
  
  int top_margin;
  int bottom_margin;
  int left_margin;
  int right_margin;

  int font_margin;
  int selection_margin;

  int extra_text_x_margin;  // If title is bigger than items, this centers items under title
  
  int item_left_offset;
  int item_width;
  int item_height;
  
  int item_select_height;
  int item_select_width;
  int item_select_left_offset;
  
  int item_x_center_offset;
  
  int item_area_height;

  int item_font_height;
  int max_item_width;

  int circle_width;

  int max_selected;

  int highlight_count;

  void              set_text_color(int item, color c);
  void              set_selected_text_color(int item, color c);
  void              set_selected_highlight_color(int item, color c);

  int               get_num_selected();

  virtual int       calculate_item_width(int item);

  virtual void      calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual void      draw_item(int num);

  virtual void      select(int num);
  virtual void      deselect(int num);

  virtual void      draw_dynamic();
  virtual void      draw_dirty();
  virtual bool      handle_event(my_event& me);

  virtual void      layout();

  void set_title(multilingua& txt);
  
  void add(multilingua& item_name, bool start_selected=false, bool disabled=false);
  
  multiselect(multilingua& title, int max_selected=-1, color bg=BLACK);

  ~multiselect();
};


#endif
