
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef MULTIWINDOW_HH
#define MULTIWINDOW_HH

#include "panel.hh"
#include "subpanel.hh"
#include "color.hh"
#include "point.hh"

#include "window.hh"
#include "List.hh"
#include "layout.hh"

class multiwindow : public window
{
public:
  
  int            num_subwindows;
  List<window>*  subwindows;
  layout_plan*   layout_calculator;

  int            target_aspect_x;
  int            target_aspect_y;
  bool           force_aspect;

  // Called from events
  virtual bool   handle_event         (my_event& me);
  void           add                  (window* win, bool stealthy = false);
  void           remove               (window* win);
  void           remove_no_delete     (window* win);  // For when a window removes itself, while in the process of deletion.
  void           remove_all           ();

  virtual void   change_layout        ( layout_plan* new_layout );
  
  // Called from vertical blank redraw, in this order, as needed.
  virtual void   layout               ();
  virtual void   draw_dirty           ();
  virtual void   draw_dynamic         ();

  virtual int    get_selected_y_offset();
  
  // Function for updating data indepently from drawing it
  virtual void   update_data          ();

                 multiwindow          (color bg = BLACK);
  virtual        ~multiwindow         ();
};



#endif
