
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#ifndef SELECTION_HH
#define SELECTION_HH

#include "color.hh"

//
// This creates a selection dialog, then re-enters
// a new input event loop until a choice is made.  Then
// it returns.
//
int ask_selection(class display*    d,
		  const char32_t*   title,
		  int               num_selections,
		  const char32_t**  selection_text,
		  color             BG_COLOR,
		  color             TITLE_COLOR,
		  color             BUTTON_COLOR,
		  const color*      TEXT_COLORS);

#endif
