
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "menu.hh"
#include "menu_item.hh"

menu_item::menu_item(color bgcolor) : window(bgcolor)
{
  mw = 0;
  sf = 0;
  data = 0;
  this->bgcolor = bgcolor;
}

void menu_item::add(window* w)
{
  if(!mw)
    {
      mw = new multiwindow(bgcolor);

      // Make the menu the parent for the multiwindow, so there is a path
      // for drawing commands.
      ((menu*)parent)->add_by_menu_item(mw);
    }
  
  mw->add(w);
}

menu_item::~menu_item()
{
  // Need to figure out how to remove this multiwindow safely from the lists.
  
  if(mw)
    parent->remove(mw);  // Will also delete it, and its subwindows
}
