
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

//

#include "multilingua.hh"

int multilingua::current_language = 0;

multilingua::multilingua()
{
  for(int i=0; i<MAX_LANGUAGES; i++)
    texts[i] = 0;
}

multilingua::operator const char32_t*() const
{
  const char32_t* t = texts[current_language];

  if(t)
    return t;

  t = texts[0];

  if(t)
    return t;

  return U"";
}

multilingua::~multilingua()
{
  for(int i=0; i<MAX_LANGUAGES; i++)
    if(texts[i])
      delete [] texts[i];
}

void multilingua::set_language(display* d, int language_number)
{
  current_language = language_number;
  d->mark_layout_dirty();  // Redraw everything, since anything might be language-dependent
}

int multilingua::get_current_language()
{
  return current_language;
}

const char32_t* multilingua::get_text(int language) const
{
  return texts[language];
}

multilingua::multilingua(const multilingua& ml)
{
  for(int i=0; i<MAX_LANGUAGES; i++)
    {
      if(!ml.texts[i])
	{
	  texts[i] = 0;
	}
      else
	{
	  int len=0;
	  while(ml.texts[i][len])
	    len++;
	  texts[i] = new char32_t[len+1];

	  for(int j=0; j<len; j++)
	    texts[i][j] = ml.texts[i][j];

	  texts[i][len] = 0;
	}
    }  
}

void multilingua::operator=(const multilingua& ml)
{
  for(int i=0; i<MAX_LANGUAGES; i++)
    {
      if(texts[i])
	delete [] texts[i];
      
      if(!ml.texts[i])
	{
	  texts[i] = 0;
	}
      else
	{
	  int len=0;
	  while(ml.texts[i][len])
	    len++;
	  texts[i] = new char32_t[len+1];

	  for(int j=0; j<len; j++)
	    texts[i][j] = ml.texts[i][j];

	  texts[i][len] = 0;
	}
    }  
}

