
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#include "multiwindow_multipane.hh"


multiwindow_multipane::multiwindow_multipane(color bg, int num_panes) : multiwindow(bg)
{
  this->num_panes = num_panes;
  
  num_subwindows_each_pane     = new int[num_panes];
  subwindows_each_pane         = new List<window>* [ num_panes ];
  layout_calculator_each_pane  = new layout_plan*  [ num_panes ];

  current_pane = 0;
  
  for(int i=0; i<num_panes; i++)
    {
      if(i!=current_pane)
	{
	  num_subwindows_each_pane[i]    = 0;
	  layout_calculator_each_pane[i] = new layout_plan;
	  subwindows_each_pane[i]        = new List<window>;
	}
    }
}


multiwindow_multipane::~multiwindow_multipane()
{
  for(int i=0; i<num_panes; i++)
    {
      if(i!=current_pane)
	{
	  delete layout_calculator_each_pane[i];
	  delete subwindows_each_pane[i];
	}
    }

  delete [] layout_calculator_each_pane;
  delete [] subwindows_each_pane;
  delete [] num_subwindows_each_pane;
}



//
// The current_panel values are stored in the multiwindow, and are invalid in
// the multiwindow_multipane.  So just copy them out replace them with the
// newly valid values.
//
void multiwindow_multipane::set_current_pane(int pane, bool stealthy)
{
  if(pane>=0 && pane<num_panes && pane!=current_pane)
    {
      num_subwindows_each_pane[current_pane]    = num_subwindows;
      subwindows_each_pane[current_pane]        = subwindows;
      layout_calculator_each_pane[current_pane] = layout_calculator;

      num_subwindows    = num_subwindows_each_pane[pane];
      subwindows        = subwindows_each_pane[pane];
      layout_calculator = layout_calculator_each_pane[pane];

      current_pane = pane;
    }

  if(!stealthy)
    {
      pane_change();
      mark_layout_dirty();
    }
}


void multiwindow_multipane::next_pane()
{
  int next_pane = (current_pane + 1) % num_panes;
  set_current_pane(next_pane);
}


void multiwindow_multipane::previous_pane()
{
  int next_pane = (current_pane + num_panes - 1) % num_panes; 
  set_current_pane(next_pane);
}


void multiwindow_multipane::add(window* win, int pane)
{
  int cpane = current_pane;
  bool stealthy = (pane != cpane);
  set_current_pane(pane, true);
  add(win, stealthy);
  set_current_pane(cpane, true);
}
