
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "select_one.hh"

extern bool draw_hotspots;

void select_one::add(multilingua& item_name, bool start_selected, bool disabled)
{
  if(num_items==MAX_ITEMS)
    {
      printf("Error: adding more items to select_one than it will hold.\n");
      abort();
    }

  this->item_name[num_items] = item_name;
  
  this->selected[num_items] = (!disabled) && (start_selected || (num_items==0));  // First item added is always selected.
  this->disabled[num_items] = disabled;
  this->textcolor[num_items]                = TEXTCOLOR;
  this->selectedtextcolor[num_items]        = SELECTEDTEXTCOLOR;
  this->selected_highlight_color[num_items] = SELECTED_HIGHLIGHT_COLOR;

  // If this one is selected, turn all the others off.
  if(start_selected)
    {
      for(int i=0; i<num_items; i++)
	this->selected[i] = false;
    }
  
  num_items++;
}


select_one::select_one(multilingua& title, color bg) :
  multiselect(title, -1, bg)
{
}


int select_one::get_item_number_selected()
{
  for(int i=0; i<num_items; i++)
    if(selected[i])
      return i;

  printf("ERROR:  No item selected in select_one!  Ignoring.\n");
  return 0;
}

void select_one::select_no_event(int item)
{
  if(!selected[item] && !disabled[item] && item>=0 && item<num_items)
    {
      for(int i=0; i<num_items; i++)
	this->selected[i] = false;

      selected[item] = true;
	mark_dirty();
    }
}

void select_one::select(int item)
{
  if(!selected[item] && !disabled[item] && item>=0 && item<num_items)
    {
      select_no_event(item);
      int returnval = 0;
      selection_changed_event sce(item, item_name[item], true);
      send_event(this, sce, returnval);
      if(change_function)
	change_function(&sce, this, change_function_data);
    }
}


// Can't deselect an item.  Instead, you must select a different one.
void select_one::deselect(int item)
{
}


select_one::~select_one()
{
}


void select_one::draw_dynamic()
{
  if(draw_hotspots || highlight_count)
    {
      if(highlight_count)
	highlight_count--;
      
      for(int i=0; i<num_items; i++)
	{
	  if(!selected[i] && !disabled[i])
	    {
	      int item_select_top_offset  = below_title_offset + top_margin + i * item_height;
      
	      point tl( item_select_left_offset,                        item_select_top_offset);
	      point tr( item_select_left_offset + item_select_width-1,  item_select_top_offset);
	      point bl( item_select_left_offset,                        item_select_top_offset+item_select_height-1);
	      point br( item_select_left_offset + item_select_width-1,  item_select_top_offset+item_select_height-1);
	      draw_line(tl, tr, GREEN);
	      draw_line(tl, bl, GREEN);
	      draw_line(tr, br, GREEN);
	      draw_line(bl, br, GREEN);
	    }
	}
    }
}
