
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "input_event_handler.hh"
#include <string.h>

int main(int argc, const char* argv[])
{
  int maxx = 1000;
  int maxy = 1000;
  
  input_event_handler eh(maxx, maxy, 0);

  if(argc==1)
    {
    }
  else if(argc==2 && !strcmp(argv[1], "-v"))
    {
      usleep(100);  // Need to wait for all the listeners to be created before they can be set to verbose.
      eh.set_verbose();
    }
  else
    {
      printf("Usage:  %s [-v]\n", argv[0]);
      exit(20);
    }
  
  for(;;)
    {
      usleep(1000);
      
      my_event me = eh.check_for_event();


      while(me.type != EVENT_NONE)
	{
	  print_event(me);
	  
	  if(me.type == EVENT_KEY_PRESS && me.key_code==KEY_ESC)
	    {
	      printf("ESC key pressed, exiting.\n");
	      exit(0);
	    }

	  me = eh.check_for_event();
	}
    }
}
