
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#ifndef MY_EVENT_QUEUE_HH
#define MY_EVENT_QUEUE_HH

#include "my_event.hh"

struct my_event_queue
{
  const static int MAX_EVENTS = 32;
  int event_in;
  int event_out;
  my_event event_rotating_buffer[MAX_EVENTS];
  my_event no_event;
  
  my_event_queue()  { event_in = 0; event_out = 0; no_event.type=EVENT_NONE; }

  my_event get_event()
  {
    if(event_out==event_in)
      return no_event;

    my_event m = event_rotating_buffer[event_out];
    event_out = (event_out + 1) % MAX_EVENTS;
    return m;
  }

  bool put_event(my_event& m)
  {
    int next_event_in = (event_in+1)%MAX_EVENTS;
    if(next_event_in==event_out)
      return false;  // No room
    event_rotating_buffer[event_in] = m;
    event_in = next_event_in;
    return true;
  }
};


#endif
