
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//


#include <stdio.h>
#include "my_event.hh"

void print_event(my_event& me)
{
      const char* L = (me.mouse_buttons_pressed & MOUSE_BUTTON_LEFT)   ? "L" : "";
      const char* M = (me.mouse_buttons_pressed & MOUSE_BUTTON_MIDDLE) ? "M" : "";
      const char* R = (me.mouse_buttons_pressed & MOUSE_BUTTON_RIGHT)  ? "R" : "";

      if(me.type == EVENT_NONE)
	{
	  printf("EVENT_NONE\n");
	}
      else if(me.type == EVENT_MOVE)
	{
	  if(me.source_mouse)
	    {
	      printf("Move, buttons %s%s%s: ", L, M, R);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	  else
	    {
	      printf("Move, %d fingers: ", me.num_touches);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	}	    
      else if(me.type == EVENT_POINTER_MOVE)
	{
	  printf("Pointer Move: (%3d,%3d)\n", me.c[0].x, me.c[0].y);
	}	    
      else if(me.type == EVENT_TOUCH)
	{
	  if(me.source_mouse)
	    {
	      printf("Touch, mouse, buttons %s%s%s: ", L, M, R);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	  else
	    {
	      printf("Touch, %d fingers: ", me.num_touches);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	}
      else if(me.type == EVENT_HOLD)
	{
	  if(me.source_mouse)
	    {
	      printf("Hold, count=%d, buttons %s%s%s: ", me.count, L, M, R);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	  else
	    {
	      printf("Hold, count=%d, %d fingers: ", me.count, me.num_touches);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	}
      else if(me.type == EVENT_RELEASE)
	{
	  if(me.source_mouse)
	    {
	      printf("Release, mouse, buttons %s%s%s: ", L, M, R);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	  else
	    {
	      printf("Release, %d fingers: ", me.num_touches);
	      for(int i=0; i<me.num_touches; i++)
		printf(" (%3d,%3d)", me.c[i].x, me.c[i].y);
	      printf("\n");
	    }
	}
      else if(me.type == EVENT_KEY_PRESS)
	{
	  printf("Key press number %d (0x%03x) (ASCII %c)\n", me.key_code, me.key_code, me.key_ascii);
	}
      else if(me.type == EVENT_KEY_HOLD)
	{
	  printf("Key hold (count=%d) number %d (0x%03x) (ASCII %c)\n", me.count, me.key_code, me.key_code, me.key_ascii);
	}
      else if(me.type == EVENT_KEY_RELEASE)
	{
	  printf("Key release number %d (0x%03x) (ASCII %c)\n", me.key_code, me.key_code, me.key_ascii);
	}
      else if(me.type == EVENT_WHEEL)
	{
	  printf("Wheel event %d, (%d,%d)\n", me.count, me.c[0].x, me.c[0].y);
	}
      else
	{
	  printf("Unknown event of type %d\n", me.type);
	}
}
