
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#ifndef INTRO_HH
#define INTRO_HH

#include "kiosk/window.hh"

class intro* setup_intro();


class intro : public window
{
  const static int blink_interval = 100;
  int              blink_count;
  bool             blink_on;
  float            ratio;

  const static int pointer_display_interval = 100;
  int              last_num;
  int              last_x[MAX_TOUCHES];
  int              last_y[MAX_TOUCHES];
  int              last_count;
  
public:

  //virtual void     calculate_width_and_height(int& calc_width, int& calc_height, int desired_height, float ratio);

  virtual bool     handle_event(my_event& me);

  virtual void     layout();
  virtual void     draw_dirty();
  virtual void     draw_dynamic();

                   intro();
                   ~intro();
};

#endif
