
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#ifndef LANGUAGES_HH
#define LANGUAGES_HH

#include "kiosk/multilingua.hh"
#include "kiosk/language_support.hh"

#define ENGLISH         0
#define CHINESE_SIMPLE  1
#define CHINESE         2
#define HINDI           3
#define SPANISH         4
#define FRENCH          5
#define ARABIC          6
#define BENGALI         7
#define UKRANIAN        8
#define PORTUGUESE      9
#define URDU           10
#define INDONESIAN     11
#define GERMAN         12
#define JAPANESE       13
#define GREEK          14
#define ITALIAN        15
#define RUSSIAN        16
#define HEBREW         17
#define NUM_LANGUAGES  18

extern const char32_t* languages[];

class select_one* setup_language_select();
class select_one* setup_decimal_select();

#endif
