
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "autogen/demo_app_svg.hh"
#include "intro.hh"
#include "languages.hh"


bool intro::handle_event(my_event& me)
{
  if(me.type == EVENT_POINTER_MOVE || me.type == EVENT_MOVE)
    {
      last_num = me.num_touches;

      int offset_x = 0;
      int offset_y = 0;
      
      window* p = this;
      while(p)
        {
          offset_x += p->offset.x;
          offset_y += p->offset.y;
          p = p->parent;
        }

      for(int i=0; i<last_num; i++)
	{
	  last_x[i] = me.c[i].x - offset_x;
	  last_y[i] = me.c[i].y - offset_y;
	}

      last_count = pointer_display_interval;
    }

  return true;  // Event handled
}


void intro::layout()
{
  layout_dirty = false;
  dirty = true;
}


void intro::draw_dirty()
{
  //printf("In intro::draw_dirty()\n");

  clear(BLACK);
  
  float designed_height = 1080.0;
  float designed_width  = 1920.0;
  float ratio_x = width / designed_width;
  float ratio_y = height / designed_height;
  ratio = (ratio_x<ratio_y) ? ratio_x : ratio_y;
  
  int size    = 400 * ratio;
  int xmargin = 80 * ratio;
  int ymargin = 40 * ratio;

  draw_svg_from_data(BxB_svg, BxB_svg_length, width - size - xmargin, ymargin, size, size);

  set_text_size(90 * ratio);

  draw_text(U"KIOSK Library Demo",
	    WHITE,
	    width/2-100*ratio,
	    220*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
  

      
  dt_colors textcolors = { GREEN7, REDRED8, WHITE };
      
  //
  // Saved as examples of multi colors
  //
  // "Signal Generator Demo\x0B (Forthcoming; now 10MHz sine)",
  // "\x0C" "Full version is for sale.\x0B (Forthcoming)\x0C  Also ask about:",
  
  set_text_size(50*ratio);

  static int init = true;

  static multilingua escape_message;
  if(init)
    {
      escape_message.set_text("Hold down the " DT_COLOR_1 "Esc" DT_COLOR_0 " key for 3 seconds to exit.", ENGLISH);
      escape_message.set_text(U"按住 " DT_COLOR_1 "Esc" DT_COLOR_0 " 键 3 秒即可退出。", CHINESE_SIMPLE);
      escape_message.set_text(U"按住 " DT_COLOR_1 "Esc" DT_COLOR_0 " 鍵 3 秒即可退出。", CHINESE);
      escape_message.set_text(U"बाहर निकलने के लिए " DT_COLOR_1 "Esc" DT_COLOR_0 " की को 3 सेकंड तक दबाए रखें।", HINDI);
      escape_message.set_text(U"Mantén pulsada la tecla " DT_COLOR_1 "Esc" DT_COLOR_0 " durante 3 segundos para salir.", SPANISH);
      escape_message.set_text(U"Maintenez la touche Échap enfoncée pendant 3 secondes pour quitter.", FRENCH);
      escape_message.set_text(U"اضغط مع الاستمرار على مفتاح " DT_COLOR_1 "Esc" DT_COLOR_0 " لمدة 3 ثوانٍ للخروج.", ARABIC);
      escape_message.set_text(U"বের হওয়ার জন্য " DT_COLOR_1 "Esc" DT_COLOR_0 " কীটি ৩ সেকেন্ড ধরে চেপে রাখুন।", BENGALI);
      escape_message.set_text(U"Утримуйте клавішу " DT_COLOR_1 "Esc" DT_COLOR_0 " протягом 3 секунд, щоб вийти.", UKRANIAN);
      escape_message.set_text(U"Mantenha a tecla " DT_COLOR_1 "Esc" DT_COLOR_0 " pressionada durante 3 segundos para sair.", PORTUGUESE);
      escape_message.set_text(U"باہر نکلنے کے لیے " DT_COLOR_1 "Esc" DT_COLOR_0 " کلید کو 3 سیکنڈ کے لیے دبائے رکھیں۔", URDU);
      escape_message.set_text(U"Tekan dan tahan tombol " DT_COLOR_1 "Esc" DT_COLOR_0 " selama 3 detik untuk keluar.", INDONESIAN);
      escape_message.set_text(U"Halten Sie die " DT_COLOR_1 "Esc" DT_COLOR_0 "-Taste 3 Sekunden lang gedrückt, um abzubrechen.", GERMAN);
      escape_message.set_text(U"終了するには、" DT_COLOR_1 "Esc" DT_COLOR_0 "キーを3秒間押し続けてください。", JAPANESE);
      escape_message.set_text(U"Κρατήστε πατημένο το πλήκτρο " DT_COLOR_1 "Esc" DT_COLOR_0 " για 3 δευτερόλεπτα για έξοδο.", GREEK);
      escape_message.set_text(U"Tenere premuto il tasto " DT_COLOR_1 "Esc" DT_COLOR_0 " per 3 secondi per uscire.", ITALIAN);
      escape_message.set_text(U"Для выхода нажмите и удерживайте клавишу " DT_COLOR_1 "Esc" DT_COLOR_0 " в течение 3 секунд.", RUSSIAN);
      escape_message.set_text(U"החזק את מקש " DT_COLOR_1 "Esc" DT_COLOR_0 " לחוץ למשך 3 שניות כדי לצאת.", HEBREW);
    }
  
  
  draw_multicolored_text(escape_message,
			 0,
			 textcolors,
			 width/2-100*ratio,
			 570*ratio,
			 DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);


  static multilingua line1;
  if(init)
    {
      line1.set_text("This library is for performing interactive graphics on", ENGLISH);
      line1.set_text("该库用于在屏幕上执行交互式图形。", CHINESE_SIMPLE);
      line1.set_text("該庫用於在螢幕上執行互動式圖形。", CHINESE);
      line1.set_text("यह लाइब्रेरी इंटरैक्टिव ग्राफ़िक्स परफ़ॉर्म करने के लिए है", HINDI);
      line1.set_text("Esta biblioteca es para realizar gráficos interactivos en", SPANISH);
      line1.set_text("Cette bibliothèque permet de réaliser des graphismes interactifs sur", FRENCH);
      line1.set_text("تُستخدم هذه المكتبة لتنفيذ الرسومات التفاعلية على", ARABIC);
      line1.set_text("এই লাইব্রেরিটি ইন্টারেক্টিভ গ্রাফিক্স সম্পাদনের জন্য", BENGALI);
      line1.set_text("Ця бібліотека призначена для створення інтерактивної графіки на", UKRANIAN);
      line1.set_text("Esta biblioteca serve para criar gráficos interativos em", PORTUGUESE);
      line1.set_text("یہ لائبریری انٹرایکٹو گرافکس پر کارکردگی دکھانے کے لیے ہے۔", URDU);
      line1.set_text("Pustaka ini digunakan untuk melakukan grafis interaktif pada", INDONESIAN);
      line1.set_text("Diese Bibliothek dient zur Darstellung interaktiver Grafiken auf", GERMAN);
      line1.set_text("このライブラリはインタラクティブなグラフィックスを実現します", JAPANESE);
      line1.set_text("Αυτή η βιβλιοθήκη δημιουργεί διαδραστικά γραφικά", GREEK);
      line1.set_text("Questa libreria è per eseguire grafica interattiva su", ITALIAN);
      line1.set_text("Эта библиотека создает интерактивную графику на", RUSSIAN);
      line1.set_text("ספרייה זו מיועדת לביצוע גרפיקה אינטראקטיבית על", HEBREW);
    }
  
  draw_text(line1,
	    WHITE,
	    width/2-100*ratio,
	    730*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua line2;
  if(init)
    {
      line2.set_text("low-powered computers without GPUs.", ENGLISH);
      line2.set_text("没有图形处理器的低功耗计算机。", CHINESE_SIMPLE);
      line2.set_text("沒有獨立顯示卡的低功耗計算機。", CHINESE);
      line2.set_text("बिना GPU वाले कम पावर वाले कंप्यूटर।", HINDI);
      line2.set_text("ordenadores de baja potencia sin GPU.", SPANISH);
      line2.set_text("ordinateurs peu performants sans processeur graphique.", FRENCH);
      line2.set_text("أجهزة كمبيوتر منخفضة الطاقة بدون وحدات معالجة رسومات.", ARABIC);
      line2.set_text("জিপিইউবিহীন কম ক্ষমতাসম্পন্ন কম্পিউটার।", BENGALI);
      line2.set_text("малопотужні комп'ютери без графічних процесорів.", UKRANIAN);
      line2.set_text("Computadores de baixo consumo de energia sem GPUs.", PORTUGUESE);
      line2.set_text("GPUs کے بغیر کم طاقت والے کمپیوٹرز۔", URDU);
      line2.set_text("komputer berdaya rendah tanpa GPU.", INDONESIAN);
      line2.set_text("Leistungsschwache Computer ohne GPUs.", GERMAN);
      line2.set_text("GPUを搭載していない低性能コンピューター。", JAPANESE);
      line2.set_text("υπολογιστές χαμηλής ισχύος χωρίς GPU.", GREEK);
      line2.set_text("computer a bassa potenza senza GPU.", ITALIAN);
      line2.set_text("маломощные компьютеры без графических процессоров.", RUSSIAN);
      line2.set_text("מחשבים בעלי צריכת חשמל נמוכה ללא כרטיסי מסך.", HEBREW);
    }

  draw_text(line2,
	    WHITE,
	    width/2-100*ratio,
	    810*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua line3;
  if(init)
    {
      line3.set_text("It is useful for embedded systems and system demos.", ENGLISH);
      line3.set_text("它适用于嵌入式系统和系统演示。", CHINESE_SIMPLE);
      line3.set_text("它適用於嵌入式系統和系統演示。", CHINESE);
      line3.set_text("यह एम्बेडेड सिस्टम और सिस्टम डेमो के लिए उपयोगी है।", HINDI);
      line3.set_text("Es útil para sistemas embebidos y demostraciones de sistemas.", SPANISH);
      line3.set_text("C'est utile pour les systèmes embarqués et les démo de systèmes.", FRENCH);
      line3.set_text("إنه مفيد للأنظمة المدمجة والعروض التوضيحية للأنظمة.", ARABIC);
      line3.set_text("এটি এমবেডেড সিস্টেম এবং সিস্টেম ডেমোর জন্য উপযোগী।", BENGALI);
      line3.set_text("Це корисно для вбудованих систем та системних демонстрацій.", UKRANIAN);
      line3.set_text("É útil para sistemas embebidos e demonstrações de sistemas.", PORTUGUESE);
      line3.set_text("یہ ایمبیڈڈ سسٹمز اور سسٹم ڈیمو کے لیے مفید ہے۔", URDU);
      line3.set_text("Ini berguna untuk sistem tertanam dan demonstrasi sistem.", INDONESIAN);
      line3.set_text("Es ist nützlich für eingebettete Systeme und Systemdemonstrationen.", GERMAN);
      line3.set_text("これは組み込みシステムやシステムデモに役立ちます。", JAPANESE);
      line3.set_text("Είναι χρήσιμο για ενσωματωμένα συστήματα και επιδείξεις συστημάτων.", GREEK);
      line3.set_text("È utile per i sistemi embedded e per le dimostrazioni di sistema.", ITALIAN);
      line3.set_text("Это полезно для встроенных систем и демонстрации работы систем.", RUSSIAN);
      line3.set_text("זה שימושי עבור מערכות משובצות והדגמות מערכות.", HEBREW);
    }

  
  draw_text(line3,
	    WHITE,
	    width/2-100*ratio,
	    890*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua line4;
  if(init)
    {
      line4.set_text("It works with a variety of input devices.", ENGLISH);
      line4.set_text("它兼容多种输入设备。", CHINESE_SIMPLE);
      line4.set_text("它可與多種輸入設備搭配使用。", CHINESE);
      line4.set_text("यह कई तरह के इनपुट डिवाइस के साथ काम करता है।", HINDI);
      line4.set_text("Funciona con una variedad de dispositivos de entrada.", SPANISH);
      line4.set_text("Il fonctionne avec une variété de périphériques d'entrée.", FRENCH);
      line4.set_text("إنه يعمل مع مجموعة متنوعة من أجهزة الإدخال.", ARABIC);
      line4.set_text("এটি বিভিন্ন ধরনের ইনপুট ডিভাইসের সাথে কাজ করে।", BENGALI);
      line4.set_text("Він працює з різноманітними пристроями введення.", UKRANIAN);
      line4.set_text("É compatível com diversos dispositivos de entrada.", PORTUGUESE);
      line4.set_text("یہ مختلف قسم کے ان پٹ آلات کے ساتھ کام کرتا ہے۔", URDU);
      line4.set_text("Perangkat ini kompatibel dengan berbagai perangkat input.", INDONESIAN);
      line4.set_text("Es funktioniert mit einer Vielzahl von Eingabegeräten.", GERMAN);
      line4.set_text("これは様々な入力デバイスに対応しています。", JAPANESE);
      line4.set_text("Λειτουργεί με μια ποικιλία συσκευών εισόδου.", GREEK);
      line4.set_text("Funziona con una varietà di dispositivi di input.", ITALIAN);
      line4.set_text("Он работает с различными устройствами ввода.", RUSSIAN);
      line4.set_text("זה עובד עם מגוון רחב של התקני קלט.", HEBREW);
    }

  
  draw_text(line4,
	    WHITE,
	    width/2-100*ratio,
	    980*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua line5;
  if(init)
    {
      line5.set_text("It works with video or web browser output.", ENGLISH);
      line5.set_text("它适用于视频或网页浏览器输出。", CHINESE_SIMPLE);
      line5.set_text("它適用於影片或網頁瀏覽器輸出。", CHINESE);
      line5.set_text("यह वीडियो या वेब ब्राउज़र आउटपुट के साथ काम करता है।", HINDI);
      line5.set_text("Funciona con salida de vídeo o navegador web.", SPANISH);
      line5.set_text("Cela fonctionne avec la sortie vidéo ou le navigateur web.", FRENCH);
      line5.set_text("يعمل مع مخرجات الفيديو أو متصفح الويب.", ARABIC);
      line5.set_text("এটি ভিডিও বা ওয়েব ব্রাউজার আউটপুটের সাথে কাজ করে।", BENGALI);
      line5.set_text("Він працює з відео або виводом веббраузера.", UKRANIAN);
      line5.set_text("Funciona com saída de vídeo ou de navegador web.", PORTUGUESE);
      line5.set_text("یہ ویڈیو یا ویب براؤزر آؤٹ پٹ کے ساتھ کام کرتا ہے۔", URDU);
      line5.set_text("Ini berfungsi dengan output video atau peramban web.", INDONESIAN);
      line5.set_text("Es funktioniert mit Video- oder Webbrowser-Ausgabe.", GERMAN);
      line5.set_text("ビデオ出力またはウェブブラウザ出力に対応しています。", JAPANESE);
      line5.set_text("Λειτουργεί με έξοδο βίντεο ή προγράμματος περιήγησης ιστού.", GREEK);
      line5.set_text("Funziona con l'output video o con il browser web.", ITALIAN);
      line5.set_text("Он работает с видео или выводом данных из веб-браузера.", RUSSIAN);
      line5.set_text("זה עובד עם פלט וידאו או דפדפן אינטרנט.", HEBREW);
    }

  
  draw_text(line5,
	    WHITE,
	    width/2-100*ratio,
	    1070*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua line6;
  if(init)
    {
      line6.set_text("It supports many demonstrated controls.", ENGLISH);
      line6.set_text("它支持许多已验证的控制功能。", CHINESE_SIMPLE);
      line6.set_text("它支援許多已驗證的控制功能。", CHINESE);
      line6.set_text("यह कई दिखाए गए कंट्रोल्स को सपोर्ट करता है।", HINDI);
      line6.set_text("Admite muchos controles demostrados.", SPANISH);
      line6.set_text("De nombreuses commandes sont prises en charge.", FRENCH);
      line6.set_text("يدعم العديد من عناصر التحكم المثبتة.", ARABIC);
      line6.set_text("এটি অনেক প্রদর্শিত নিয়ন্ত্রণ সমর্থন করে।", BENGALI);
      line6.set_text("підтримується багато елементів керування.", UKRANIAN);
      line6.set_text("Suporta muitos controlos comprovados.", PORTUGUESE);
      line6.set_text("یہ بہت سے ظاہر شدہ کنٹرولز کی حمایت کرتا ہے۔", URDU);
      line6.set_text("Ini mendukung banyak kontrol yang telah terbukti.", INDONESIAN);
      line6.set_text("Es unterstützt viele bewährte Steuerungselemente.", GERMAN);
      line6.set_text("多くの実証済みのコントロールをサポートします。", JAPANESE);
      line6.set_text("Υποστηρίζει πολλά αποδεδειγμένα χειριστήρια.", GREEK);
      line6.set_text("Supporta molti controlli dimostrati.", ITALIAN);
      line6.set_text("Поддерживается множество элементов управления.", RUSSIAN);
      line6.set_text("הוא תומך בבקרות רבות שהוכחו.", HEBREW);
    }

  
  draw_text(line6,
	    WHITE,
	    width/2-100*ratio,
	    1160*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua line7;
  if(init)
    {
      line7.set_text("Internationalization is demonstrated on some pages.", ENGLISH);
      line7.set_text("部分页面展示了国际化功能。", CHINESE_SIMPLE);
      line7.set_text("部分頁面體現了國際化理念。", CHINESE);
      line7.set_text("इंटरनेशनलाइज़ेशन कुछ पेजों पर दिखाया गया है।", HINDI);
      line7.set_text("La internacionalización se evidencia en algunas páginas.", SPANISH);
      line7.set_text("L'internationalisation est visible sur certaines pages.", FRENCH);
      line7.set_text("يتم عرض ميزات التدويل في بعض الصفحات.", ARABIC);
      line7.set_text("কিছু পৃষ্ঠায় আন্তর্জাতিকীকরণ প্রদর্শিত হয়েছে।", BENGALI);
      line7.set_text("Інтернаціоналізація продемонстрована на деяких сторінках.", UKRANIAN);
      line7.set_text("A internacionalização é demonstrada em algumas páginas.", PORTUGUESE);
      line7.set_text("کچھ صفحات پر بین الاقوامی کاری کا مظاہرہ کیا گیا ہے۔", URDU);
      line7.set_text("Internasionalisasi ditunjukkan di beberapa halaman.", INDONESIAN);
      line7.set_text("Die Internationalisierung wird auf einigen Seiten veranschaulicht.", GERMAN);
      line7.set_text("一部のページでは国際化への対応が示されています。", JAPANESE);
      line7.set_text("Η διεθνοποίηση καταδεικνύεται σε ορισμένες σελίδες.", GREEK);
      line7.set_text("L'internazionalizzazione è visibile in alcune pagine.", ITALIAN);
      line7.set_text("На некоторых страницах реализована поддержка нескольких языков.", RUSSIAN);
      line7.set_text("בינלאומיות מודגמת בכמה עמודים.", HEBREW);
    }

  
  draw_text(line7,
	    WHITE,
	    width/2-100*ratio,
	    1250*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);


  static multilingua selected_language;
  if(init)
    {
      selected_language.set_text("Selected Language:", ENGLISH);
      selected_language.set_text("选择的语言", CHINESE_SIMPLE);
      selected_language.set_text("選定語言", CHINESE);
      selected_language.set_text("चयनित भाषा", HINDI);
      selected_language.set_text("Idioma seleccionado", SPANISH);
      selected_language.set_text("Langue sélectionnée", FRENCH);
      selected_language.set_text("اللغة المختارة", ARABIC);
      selected_language.set_text("নির্বাচিত ভাষা", BENGALI);
      selected_language.set_text("Вибрана мова", UKRANIAN);
      selected_language.set_text("Idioma selecionado", PORTUGUESE);
      selected_language.set_text("منتخب کردہ زبان", URDU);
      selected_language.set_text("Bahasa yang dipilih", INDONESIAN);
      selected_language.set_text("Ausgewählte Sprache", GERMAN);
      selected_language.set_text("選択された言語", JAPANESE);
      selected_language.set_text("Επιλεγμένη γλώσσα", GREEK);
      selected_language.set_text("Lingua selezionata", ITALIAN);
      selected_language.set_text("Выбранный язык", RUSSIAN);
      selected_language.set_text("שפה שנבחרה", HEBREW);
    }
  
  draw_text(selected_language,
	    GREEN,
	    width/2-100*ratio,
	    1400*ratio,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  // Language isn't printed here, but instead in draw_dynamic(), to make it blink

  init = false;
  dirty = false;
}


void intro::draw_dynamic()
{
  if(blink_count>=blink_interval)
    {
      blink_on = !blink_on;
      blink_count = 0;
    }
  else
    {
      blink_count++;
    }


  if(blink_on)
    {
      static int init = true;
      static multilingua ml;
  
      if(init)
	{
	  for(int i=0; languages[i]; i++)
	    ml.set_text(languages[i], i);
	  
	  init = false;
	}
      
      draw_text(ml,
		WHITE,
		width/2-100*ratio,
		1480*ratio,
		DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);      
    }

  if(last_count)
    {
      last_count--;

      color colors[]   = { WHITE, RED, GREEN, BLUE, ORANGE, BLUEGREEN, PURPLE, YELLOW, GREY };
      int   num_colors = sizeof(colors) / sizeof(colors[0]);
      
      point p0, p1;

      for(int i=0; i<last_num; i++)
	{
	  color c = colors[i%num_colors];
      
	  p0.x = 0;
	  p1.x = width;
	  p0.y = last_y[i];
	  p1.y = last_y[i];
	  
	  draw_line_horizontal(p0, p1, c);
	  
	  p0.x = last_x[i];
	  p1.x = last_x[i];
	  p0.y = 0;
	  p1.y = height;
	  draw_line_vertical(p0, p1, c);
	}
    }
}


intro::intro() : window(BLACK)
{
  blink_count  = 0;
  blink_on     = false;
  ratio        = 1;

  last_count   = 0;
}


intro::~intro()
{
}


intro* setup_intro()
{
  intro* intro_window = new intro();
  return intro_window;
}
