
// SPDX-License-Identifier: CC-BY-NC-SA-4.0
//
// Copyright (C) 2026 Bit by Bit Signal Processing LLC (https://bxbsp.com)
//
// This work is placed under the "Creative Commons Attribution
// NonCommercial ShareAlike 4.0 International" license, known
// by the shortened acronym "CC-BY-NC-SA-4.0".
//
// This work is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
// A CC-BY-NC-SA-4.0 license allows you to use this work for
// noncommercial purposes so long as attribution is made to the
// original author.  Modified versions of this work may be distributed,
// but only under the same license.  For further details, see the
// Creative Commons License "CC-BY-NC-SA-4.0".
//
// You should have received a copy of the CC-BY-NC-SA-4.0 license
// along with this work. If not, see
// <https://creativecommons.org/licenses/by-nc-sa/4.0/>.
//

#include "kiosk/window.hh"
#include "kiosk/multiwindow.hh"
#include "kiosk/multiselect.hh"
#include "kiosk/unalingua.hh"

#include "multiselect_demo.hh"
#include "languages.hh"

void selection_changed_function(selection_changed_event* sce, class multiselect* ms, void* data);


class multiselect_demo_window : public multiwindow
{
  multiselect* ms;

  int             NUM_FAVS;
  multilingua*    favorite_colors;
  dt_colors       fav_colors;

  virtual void layout();
  virtual void draw_dirty();
  virtual void draw_dynamic();

public:

  const static int text_display_interval    = 100;
  unalingua        last_text;
  int              last_text_count;

  multiselect_demo_window();
  ~multiselect_demo_window();
};

window* create_multiselect_demo_window()
{
  return new multiselect_demo_window();
}


multiselect_demo_window::~multiselect_demo_window()
{
}

multiselect_demo_window::multiselect_demo_window()
{
  last_text_count    = 0;
  
  int   max_selected = -1;
  color bg           = BLACK;

  multilingua title;

  title.set_text("Multiselect", ENGLISH);

#ifdef NOTDEF
  title.set_text(U"", CHINESE_SIMPLE);
  title.set_text(U"", CHINESE);
  title.set_text(U"", HINDI);
  title.set_text(U"", SPANISH);
  title.set_text(U"", FRENCH);
  title.set_text(U"", ARABIC);
  title.set_text(U"", BENGALI);
  title.set_text(U"", UKRANIAN);
  title.set_text(U"", PORTUGUESE);
  title.set_text(U"", URDU);
  title.set_text(U"", INDONESIAN);
  title.set_text(U"", GERMAN);
  title.set_text(U"", JAPANESE);
  title.set_text(U"", GREEK);
  title.set_text(U"", ITALIAN);
  title.set_text(U"", RUSSIAN);
  title.set_text(U"", HEBREW);
#endif
  
  NUM_FAVS = 6;

  favorite_colors = new multilingua[NUM_FAVS];
  
  favorite_colors[0].set_text("Red", ENGLISH);
  favorite_colors[0].set_text(U"红色的", CHINESE_SIMPLE);
  favorite_colors[0].set_text(U"紅色的", CHINESE);
  favorite_colors[0].set_text(U"लाल", HINDI);
  favorite_colors[0].set_text(U"Roja", SPANISH);
  favorite_colors[0].set_text(U"Rouge", FRENCH);
  favorite_colors[0].set_text(U"أحمر", ARABIC);
  favorite_colors[0].set_text(U"লাল", BENGALI);
  favorite_colors[0].set_text(U"Червоний", UKRANIAN);
  favorite_colors[0].set_text(U"Vermelha", PORTUGUESE);
  favorite_colors[0].set_text(U"سرخ", URDU);
  favorite_colors[0].set_text(U"Merah", INDONESIAN);
  favorite_colors[0].set_text(U"Rot", GERMAN);
  favorite_colors[0].set_text(U"赤", JAPANESE);
  favorite_colors[0].set_text(U"Κόκκινος", GREEK);
  favorite_colors[0].set_text(U"Rossa", ITALIAN);
  favorite_colors[0].set_text(U"Красный", RUSSIAN);
  favorite_colors[0].set_text(U"אָדוֹם", HEBREW);
      
  favorite_colors[1].set_text("Green", ENGLISH);
  favorite_colors[1].set_text(U"绿色的", CHINESE_SIMPLE);
  favorite_colors[1].set_text(U"綠色的", CHINESE);
  favorite_colors[1].set_text(U"हरा", HINDI);
  favorite_colors[1].set_text(U"Verde", SPANISH);
  favorite_colors[1].set_text(U"Verte", FRENCH);
  favorite_colors[1].set_text(U"أخضر", ARABIC);
  favorite_colors[1].set_text(U"সবুজ", BENGALI);
  favorite_colors[1].set_text(U"Зелений", UKRANIAN);
  favorite_colors[1].set_text(U"Verde", PORTUGUESE);
  favorite_colors[1].set_text(U"سبز", URDU);
  favorite_colors[1].set_text(U"Hijau", INDONESIAN);
  favorite_colors[1].set_text(U"Grün", GERMAN);
  favorite_colors[1].set_text(U"緑", JAPANESE);
  favorite_colors[1].set_text(U"Πράσινος", GREEK);
  favorite_colors[1].set_text(U"Verde", ITALIAN);
  favorite_colors[1].set_text(U"Зеленый", RUSSIAN);
  favorite_colors[1].set_text(U"יָרוֹק", HEBREW);
  
  favorite_colors[2].set_text("Blue", ENGLISH);
  favorite_colors[2].set_text(U"蓝色的", CHINESE_SIMPLE);
  favorite_colors[2].set_text(U"藍色的", CHINESE);
  favorite_colors[2].set_text(U"नीला", HINDI);
  favorite_colors[2].set_text(U"Azul", SPANISH);
  favorite_colors[2].set_text(U"Bleue", FRENCH);
  favorite_colors[2].set_text(U"أزرق", ARABIC);
  favorite_colors[2].set_text(U"নীল", BENGALI);
  favorite_colors[2].set_text(U"Синій", UKRANIAN);
  favorite_colors[2].set_text(U"Azul", PORTUGUESE);
  favorite_colors[2].set_text(U"نیلا", URDU);
  favorite_colors[2].set_text(U"Biru", INDONESIAN);
  favorite_colors[2].set_text(U"Blau", GERMAN);
  favorite_colors[2].set_text(U"青", JAPANESE);
  favorite_colors[2].set_text(U"Μπλε", GREEK);
  favorite_colors[2].set_text(U"Blu", ITALIAN);
  favorite_colors[2].set_text(U"Синий", RUSSIAN);
  favorite_colors[2].set_text(U"כְּחוֹל", HEBREW);
  
  favorite_colors[3].set_text("Yellow", ENGLISH);
  favorite_colors[3].set_text(U"黄色的", CHINESE_SIMPLE);
  favorite_colors[3].set_text(U"黃色的", CHINESE);
  favorite_colors[3].set_text(U"पीला", HINDI);
  favorite_colors[3].set_text(U"Amarilla", SPANISH);
  favorite_colors[3].set_text(U"Jaune", FRENCH);
  favorite_colors[3].set_text(U"أصفر", ARABIC);
  favorite_colors[3].set_text(U"হলুদ", BENGALI);
  favorite_colors[3].set_text(U"Жовтий", UKRANIAN);
  favorite_colors[3].set_text(U"Amarela", PORTUGUESE);
  favorite_colors[3].set_text(U"پیلا", URDU);
  favorite_colors[3].set_text(U"Kuning", INDONESIAN);
  favorite_colors[3].set_text(U"Gelb", GERMAN);
  favorite_colors[3].set_text(U"黄色", JAPANESE);
  favorite_colors[3].set_text(U"Κίτρινος", GREEK);
  favorite_colors[3].set_text(U"Gialla", ITALIAN);
  favorite_colors[3].set_text(U"Желтый", RUSSIAN);
  favorite_colors[3].set_text(U"צָהוֹב", HEBREW);
  
  favorite_colors[4].set_text("Orange", ENGLISH);
  favorite_colors[4].set_text(U"橙子", CHINESE_SIMPLE);
  favorite_colors[4].set_text(U"橘子", CHINESE);
  favorite_colors[4].set_text(U"नारंगी", HINDI);
  favorite_colors[4].set_text(U"Naranja", SPANISH);
  favorite_colors[4].set_text(U"Orange", FRENCH);
  favorite_colors[4].set_text(U"البرتقالي", ARABIC);
  favorite_colors[4].set_text(U"কমলা", BENGALI);
  favorite_colors[4].set_text(U"Помаранчевий", UKRANIAN);
  favorite_colors[4].set_text(U"Laranja", PORTUGUESE);
  favorite_colors[4].set_text(U"کینو", URDU);
  favorite_colors[4].set_text(U"Oranye", INDONESIAN);
  favorite_colors[4].set_text(U"Orange", GERMAN);
  favorite_colors[4].set_text(U"オレンジ", JAPANESE);
  favorite_colors[4].set_text(U"Πορτοκάλι", GREEK);
  favorite_colors[4].set_text(U"Arancia", ITALIAN);
  favorite_colors[4].set_text(U"Апельсин", RUSSIAN);
  favorite_colors[4].set_text(U"כָּתוֹם", HEBREW);
  
  favorite_colors[5].set_text("Purple", ENGLISH);
  favorite_colors[5].set_text(U"紫色的", CHINESE_SIMPLE);
  favorite_colors[5].set_text(U"紫色的", CHINESE);
  favorite_colors[5].set_text(U"बैंगनी", HINDI);
  favorite_colors[5].set_text(U"Púrpura", SPANISH);
  favorite_colors[5].set_text(U"Violette", FRENCH);
  favorite_colors[5].set_text(U"أرجواني", ARABIC);
  favorite_colors[5].set_text(U"বেগুনি", BENGALI);
  favorite_colors[5].set_text(U"Фіолетовий", UKRANIAN);
  favorite_colors[5].set_text(U"Roxa", PORTUGUESE);
  favorite_colors[5].set_text(U"جامنی", URDU);
  favorite_colors[5].set_text(U"Ungu", INDONESIAN);
  favorite_colors[5].set_text(U"Lila", GERMAN);
  favorite_colors[5].set_text(U"紫", JAPANESE);
  favorite_colors[5].set_text(U"Μωβ", GREEK);
  favorite_colors[5].set_text(U"Viola", ITALIAN);
  favorite_colors[5].set_text(U"Фиолетовый", RUSSIAN);
  favorite_colors[5].set_text(U"סָגוֹל", HEBREW);

  ms = new multiselect(title, max_selected, bg);

  multilingua txt;
  

  dt_colors fcolors = { WHITE, RED, GREEN, BLUE, YELLOW, ORANGE, PURPLE };
  fav_colors = fcolors;

  for(int i=0; i<NUM_FAVS; i++)
    {
      ms->add(favorite_colors[i], false /*start_selected*/, false /* disabled */ );
      ms->set_text_color(i, fcolors.c[i+1]);
      ms->set_selected_text_color(i, BLACK);
      ms->set_selected_highlight_color(i, fcolors.c[i+1]);
    }

  ms->change_function      = selection_changed_function;
  ms->change_function_data = this;

  
  add(ms);
}


void selection_changed_function(selection_changed_event* sce, class multiselect* ms, void* data)
{
  multiselect_demo_window* mdw = (multiselect_demo_window*) data;
  mdw->last_text_count = mdw->text_display_interval;
  
  static bool init = true;
  static multilingua selected;
  if(init)
    {
      selected.set_text("selected", ENGLISH);
      selected.set_text(U"已选择", CHINESE_SIMPLE);
      selected.set_text(U"已選", CHINESE);
      selected.set_text(U"चयनित", HINDI);
      selected.set_text(U"seleccionado", SPANISH);
      selected.set_text(U"choisi", FRENCH);
      selected.set_text(U"مختار", ARABIC);
      selected.set_text(U"নির্বাচিত", BENGALI);
      selected.set_text(U"вибраний", UKRANIAN);
      selected.set_text(U"selecionado", PORTUGUESE);
      selected.set_text(U"منتخب", URDU);
      selected.set_text(U"terpilih", INDONESIAN);
      selected.set_text(U"ausgewählt", GERMAN);
      selected.set_text(U"選択済み", JAPANESE);
      selected.set_text(U"επιλεγμένο", GREEK);
      selected.set_text(U"selezionato", ITALIAN);
      selected.set_text(U"выбранный", RUSSIAN);
      selected.set_text(U"נִבחָר", HEBREW);
    }
 
  unalingua txt = DT_COLOR_0 " ";
  txt.append_text( selected.get_text() );
  
  mdw->last_text = txt;
  init = false;
}


void multiselect_demo_window::layout()
{
  //b->resize(20*width/100, 60*height/100, 60*width/100, 20*height/100);
  ms->resize(width/10, height/10, 9*width/10, 9*height/10);
  ms->layout();

  layout_dirty = false;
  dirty = true;
}

void multiselect_demo_window::draw_dynamic()
{
  if(last_text_count)
    {
      last_text_count--;

      int ypos = height*15/100;
      
      dt_colors draw_colors;    
      for(int i=0; i<MAX_COLORS; i++)
        draw_colors.c[i] = scale(fav_colors.c[i], BLACK, last_text_count / (float) text_display_interval);
      
      set_text_size(height/25);

      //draw_line(point(0, height*60/100), point(width-1, height*60/100), RED);

      for(int item=0; item<ms->num_items; item++)
        {
          if(ms->selected[item])
            {
              char tmp[2];
              tmp[0] = 10+item+1;  // A color selection for draw_multicolored_text
              tmp[1] = 0;

              unalingua txt = tmp;
              txt.append_text(ms->item_name[item]);
              txt.append_text(last_text);

              draw_multicolored_text(txt.get_text(),
                                     0,
                                     draw_colors,
                                     6*width/10,
                                     ypos,
                                     DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);
              ypos += height/20;
            }
        }
    }
  
  multiwindow::draw_dynamic();
}

void multiselect_demo_window::draw_dirty()
{
  multiwindow::draw_dirty();
    
  point p0(0,0);
  point p1(width-1, 0);
  point p2(width-1, height-1);
  point p3(0, height-1);

  draw_line_vertical(p1, p2, GREY7);
  draw_line_vertical(p0, p3, GREY7);
  draw_line_horizontal(p0, p1, GREY7);
  draw_line_horizontal(p2, p3, GREY7);
  
  set_text_size(height/25);

  static bool init = true;

  static multilingua multiselect_demo;
  if(init)
    {
      multiselect_demo.set_text("Multiselect Demo", ENGLISH);
      multiselect_demo.set_text(U"Multiselect 演示", CHINESE_SIMPLE);
      multiselect_demo.set_text(U"Multiselect 示範", CHINESE);
      multiselect_demo.set_text(U"Multiselect डेमो", HINDI);
      multiselect_demo.set_text(U"Multiselect manifestación", SPANISH);
      multiselect_demo.set_text(U"Multiselect démo", FRENCH);
      multiselect_demo.set_text(U"Multiselect عرض توضيحي", ARABIC);
      multiselect_demo.set_text(U"Multiselect ডেমো", BENGALI);
      multiselect_demo.set_text(U"Multiselect демоверсія", UKRANIAN);
      multiselect_demo.set_text(U"Multiselect demonstração", PORTUGUESE);
      multiselect_demo.set_text(U"Multiselect ڈیمو", URDU);
      multiselect_demo.set_text(U"Multiselect demo", INDONESIAN);
      multiselect_demo.set_text(U"Multiselect Demo", GERMAN);
      multiselect_demo.set_text(U"Multiselect デモ", JAPANESE);
      multiselect_demo.set_text(U"Multiselect διαδήλωση", GREEK);
      multiselect_demo.set_text(U"Multiselect dimostrazione", ITALIAN);
      multiselect_demo.set_text(U"Multiselect демо", RUSSIAN);
      multiselect_demo.set_text(U"Multiselect הַדגָמָה", HEBREW);
    }
  
  draw_text(multiselect_demo,
	    WHITE,
	    width/2,
	    height*1/20,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  set_text_size(height/50);

  color c = GREY5;
  static multilingua txt1;
  if(init)
    {
      txt1.set_text("Multiple selections use a 'multiselect' control.", ENGLISH);
      txt1.set_text(U"多项选择使用“多选”控件。", CHINESE_SIMPLE);
      txt1.set_text(U"多項選擇使用「多選」控制項。", CHINESE);
      txt1.set_text(U"मल्टीपल सिलेक्शन के लिए 'मल्टीसेलेक्ट' कंट्रोल का इस्तेमाल होता है।", HINDI);
      txt1.set_text(U"La selección de múltiples opciones se realiza mediante un control de selección múltiple.", SPANISH);
      txt1.set_text(U"La sélection de plusieurs éléments s'effectue à l'aide d'un contrôle de sélection multiple.", FRENCH);
      txt1.set_text(U"يتم استخدام عنصر تحكم \"التحديد المتعدد\" للاختيارات المتعددة.", ARABIC);
      txt1.set_text(U"একাধিক নির্বাচনের জন্য একটি 'মাল্টিসিলেক্ট' কন্ট্রোল ব্যবহার করা হয়।", BENGALI);
      txt1.set_text(U"Для кількох варіантів вибору використовується елемент керування «багаторазовим вибором».", UKRANIAN);
      txt1.set_text(U"As seleções múltiplas utilizam um controlo de 'seleção múltipla'.", PORTUGUESE);
      txt1.set_text(U"متعدد انتخاب ایک 'ملٹی سلیکٹ' کنٹرول کا استعمال کرتے ہیں۔", URDU);
      txt1.set_text(U"Pemilihan berganda menggunakan kontrol 'multiselect'.", INDONESIAN);
      txt1.set_text(U"Für Mehrfachauswahlen wird ein „Multiselect“-Steuerelement verwendet.", GERMAN);
      txt1.set_text(U"複数の項目を選択する場合は、「マルチセレクト」コントロールを使用します。", JAPANESE);
      txt1.set_text(U"Οι πολλαπλές επιλογές χρησιμοποιούν ένα στοιχείο ελέγχου «πολλαπλής επιλογής».", GREEK);
      txt1.set_text(U"La selezione multipla utilizza un controllo \"multiselect\".", ITALIAN);
      txt1.set_text(U"Для выбора нескольких элементов используется элемент управления «множественный выбор».", RUSSIAN);
      txt1.set_text(U"בחירות מרובות משתמשות בפקד 'בחירה מרובה'.", HEBREW);
    }
  
  draw_text(txt1,
	    c,
	    width/2,
	    height*20/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);


  static multilingua txt1a;
  if(init)
    {
      txt1a.set_text("'Multiselect', 'ask_selection', and 'select_one' all make selections.", ENGLISH);
      txt1a.set_text(U"“多项选择”、“询问选择”和“单项选择”都用于进行选择。", CHINESE_SIMPLE);
      txt1a.set_text(U"'Multiselect'、'ask_selection' 和 'select_one' 都用於進行選擇。", CHINESE);
      txt1a.set_text(U"'मल्टीसेलेक्ट', 'आस्क_सिलेक्शन', और 'सेलेक्ट_वन' ये सभी सिलेक्शन करते हैं।", HINDI);
      txt1a.set_text(U"'multiselect', 'ask_selection' y 'select_one' permiten realizar selecciones.", SPANISH);
      txt1a.set_text(U"« multiselect », « ask_selection » et « select_one » permettent toutes d'effectuer des sélections.", FRENCH);
      txt1a.set_text(U"تقوم كل من \"multiselect\" و\"ask_selection\" و\"select_one\" بإجراء عمليات اختيار.", ARABIC);
      txt1a.set_text(U"'মাল্টিসিলেক্ট', 'আস্ক_সিলেকশন' এবং 'সিলেক্ট_ওয়ান' সবগুলোই নির্বাচনের কাজ করে।", BENGALI);
      txt1a.set_text(U"«Multiselect», «ask_selection» та «select_one» виконують вибір.", UKRANIAN);
      txt1a.set_text(U"'Multiselect', 'ask_selection' e 'select_one' permitem fazer seleções.", PORTUGUESE);
      txt1a.set_text(U"'ملٹی سلیکٹ'، 'اسک_سلیکشن'، اور 'سلیکٹ_ون' سبھی انتخاب کرتے ہیں۔", URDU);
      txt1a.set_text(U"'Multiselect', 'ask_selection', dan 'select_one' semuanya digunakan untuk melakukan pemilihan.", INDONESIAN);
      txt1a.set_text(U"„Multiselect“, „ask_selection“ und „select_one“ dienen alle der Auswahl von Elementen.", GERMAN);
      txt1a.set_text(U"「Multiselect」、「ask_selection」、「select_one」はすべて選択を行う機能です。", JAPANESE);
      txt1a.set_text(U"Οι επιλογές 'Multiselect', 'ask_selection' και 'select_one' είναι όλες επιλογές.", GREEK);
      txt1a.set_text(U"Le funzioni 'multiselect', 'ask_selection' e 'select_one' consentono tutte di effettuare delle selezioni.", ITALIAN);
      txt1a.set_text(U"Функции «multiselect», «ask_selection» и «select_one» используются для выбора элементов.", RUSSIAN);
      txt1a.set_text(U"הפונקציות 'Multiselect', 'ask_selection' ו-'select_one' כולן מבצעות בחירות.", HEBREW);
    }
  
  draw_text(txt1a,
	    c,
	    width/2,
	    height*22/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  
  static multilingua txt2;
  if(init)
    {
      txt2.set_text("Only 'multiselect' allows multiple items to be selected.", ENGLISH);
      txt2.set_text(U"只有“多选”模式允许选择多个项目。", CHINESE_SIMPLE);
      txt2.set_text(U"只有“多選”選項才允許選擇多個項目。", CHINESE);
      txt2.set_text(U"सिर्फ 'मल्टीसेलेक्ट' ही एक साथ कई आइटम सेलेक्ट करने की अनुमति देता है।", HINDI);
      txt2.set_text(U"Solo la opción de \"multiselect\" permite seleccionar varios elementos.", SPANISH);
      txt2.set_text(U"Seul le mode « sélection multiple » permet de sélectionner plusieurs éléments.", FRENCH);
      txt2.set_text(U"تتيح خاصية \"الاختيار المتعدد\" فقط إمكانية تحديد عناصر متعددة.", ARABIC);
      txt2.set_text(U"শুধুমাত্র 'মাল্টিসিলেক্ট' একাধিক আইটেম নির্বাচন করার সুযোগ দেয়।", BENGALI);
      txt2.set_text(U"Тільки «множинний вибір» дозволяє вибрати кілька елементів.", UKRANIAN);
      txt2.set_text(U"Apenas a opção 'multiselect' permite selecionar vários itens.", PORTUGUESE);
      txt2.set_text(U"صرف 'ملٹی سلیکٹ' متعدد آئٹمز کو منتخب کرنے کی اجازت دیتا ہے۔", URDU);
      txt2.set_text(U"Hanya opsi 'multiselect' yang memungkinkan pemilihan beberapa item sekaligus.", INDONESIAN);
      txt2.set_text(U"Nur bei der Option „Multiselect“ können mehrere Elemente ausgewählt werden.", GERMAN);
      txt2.set_text(U"「マルチセレクト」機能のみが、複数の項目を選択することを可能にします。", JAPANESE);
      txt2.set_text(U"Μόνο η «πολλαπλή επιλογή» επιτρέπει την επιλογή πολλαπλών στοιχείων.", GREEK);
      txt2.set_text(U"Solo la modalità \"multiselect\" consente di selezionare più elementi contemporaneamente.", ITALIAN);
      txt2.set_text(U"Только режим «множественного выбора» позволяет выбирать несколько элементов.", RUSSIAN);
      txt2.set_text(U"רק 'בחירה מרובה' מאפשרת בחירה של מספר פריטים.", HEBREW);
    }
  draw_text(txt2,
	    c,
	    width/2,
	    height*24/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  static multilingua txt3;
  if(init)
    {
      txt3.set_text("Selection changes generate actions.", ENGLISH);
      txt3.set_text(U"选择项的改变会触发相应的操作。", CHINESE_SIMPLE);
      txt3.set_text(U"選擇更改會觸發操作。", CHINESE);
      txt3.set_text(U"सिलेक्शन में बदलाव से एक्शन जेनरेट होते हैं।", HINDI);
      txt3.set_text(U"Los cambios en la selección generan acciones.", SPANISH);
      txt3.set_text(U"Les modifications de sélection génèrent des actions.", FRENCH);
      txt3.set_text(U"تؤدي تغييرات التحديد إلى توليد إجراءات.", ARABIC);
      txt3.set_text(U"নির্বাচনের পরিবর্তনগুলো কর্মের জন্ম দেয়।", BENGALI);
      txt3.set_text(U"Зміни вибору генерують дії.", UKRANIAN);
      txt3.set_text(U"As alterações de seleção geram ações.", PORTUGUESE);
      txt3.set_text(U"انتخاب میں تبدیلیاں عمل پیدا کرتی ہیں۔", URDU);
      txt3.set_text(U"Perubahan dalam pemilihan akan menghasilkan tindakan.", INDONESIAN);
      txt3.set_text(U"Auswahländerungen lösen Aktionen aus.", GERMAN);
      txt3.set_text(U"選択内容の変更はアクションを引き起こします。", JAPANESE);
      txt3.set_text(U"Οι αλλαγές στην επιλογή δημιουργούν ενέργειες.", GREEK);
      txt3.set_text(U"Le modifiche alla selezione generano azioni.", ITALIAN);
      txt3.set_text(U"Изменения в выборе элементов приводят к определенным действиям.", RUSSIAN);
      txt3.set_text(U"שינויים בבחירה יוצרים פעולות.", HEBREW);
    }
  draw_text(txt3,
	    c,
	    width/2,
	    height*26/40,
	    DRAW_TEXT_X_CENTER|DRAW_TEXT_Y_TOP|DRAW_TEXT_ROTATE_0);

  init = false;
}


