#!/bin/bash

SIZES="16 32 36 48 64 72 96 120 128 144 152 180 192 256 384 512"

mkdir -p webfiles

cat >webfiles/manifest.json <<EOF
{
  "name": "BxB",
  "icons": [
EOF

PNGs=""

for size in $SIZES; do

    PNG=autogen/BxB_${size}x${size}.png
    PNGs="$PNGs $PNG"
    
    convert -scale ${size}x${size} -background none libsrc/BxB.svg $PNG

    cat >>webfiles/manifest.json <<EOF
    {
      "src": "BxB_${size}x${size}.png",
      "sizes": "${size}x${size}",
      "type": "image/png"
    },
EOF

done

cat >>webfiles/manifest.json <<EOF
  ],
  "theme_color": "#000000",
  "background_color": "#000000",
  "start_url": "index.html",
  "display": "fullscreen",
  "orientation": "landscape"
}
EOF

convert $PNGs webfiles/favicon.ico

#
# favicon.ico is used by browsers to display a cute little logo in the upper left of the browser toolbar
#

identify webfiles/favicon.ico

echo ""
echo "Output should have identified icons in sizes from 16x16 to 128x128."
echo "if so, icon is produced as favicon.ico"
echo ""
